//+------------------------------------------------------------------+
//|                                                    YOLOv8 EA.mq5 |
//|                                          Copyright 2023, Omegafx |
//|                 https://www.mql5.com/en/users/omegajoctan/seller |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, Omegafx"
#property link      "https://www.mql5.com/en/users/omegajoctan/seller"
#property version   "1.00"

#include <errordescription.mqh>

input uint chart_scale = 3;
input uint timer_seconds = 60;

int chart_width, chart_height;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   
   if (!EventSetTimer(timer_seconds))
     {
       printf("%s failed to set the timer, Error = %d",__FUNCTION__,GetLastError());
       return INIT_FAILED;
     }

    showBars(true);   
         
//---

   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---

    //showBars(true);   
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnTimer(void)
  {   
//---

    showBars(true); //explicitly show the bars
    
    // Clear the objects before taking a screenshot
    ObjectsDeleteAll(0);
    ObjectsDeleteAll(0,0);
    
    if (takeScreenShot())
     {
       Print("Screen shot taken: ",TimeCurrent());
       Sleep(100);
     }
     
    chart_width = (int)ChartGetInteger(0, CHART_WIDTH_IN_PIXELS);
    chart_height = (int)ChartGetInteger(0, CHART_HEIGHT_IN_PIXELS);
           
//--- Take screenshot
    
    MqlDateTime time_struct;
    TimeToStruct(TimeLocal(), time_struct);
   
    string filename = StringFormat("\\Files\\YOLOv8 Images\\%s.%s.%d.%d.%d.bmp",Symbol(),EnumToString(Period()),time_struct.day, time_struct.day_of_week, time_struct.hour);
    string fileshort_name = filename;
    
    bool checkfile = false;
    if (StringReplace(fileshort_name, "\\Files\\","")>0)
      checkfile = true; //If the parent folder was removed we can proceed to check if a file exists before drawing an object
      
    if (checkfile)
     while (!FileIsExist(fileshort_name)) 
       {
         printf("%s not found",fileshort_name);
         return;
       }
        
//--- Set the image with patterns detected to a chart

    if (!chartBackGroundSet(filename, chart_width, chart_height))
        return;
        
    showBars(false);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool takeScreenShot()
 {
//--- Hide price and time scales temporarily

    bool original_price_scale = (bool)ChartGetInteger(0, CHART_SHOW_PRICE_SCALE);
    bool original_time_scale = (bool)ChartGetInteger(0, CHART_SHOW_DATE_SCALE);
    bool original_foreground_color = ChartGetInteger(0, CHART_COLOR_FOREGROUND);
    bool original_background_color = ChartGetInteger(0, CHART_COLOR_BACKGROUND);
    
    ChartSetInteger(0, CHART_SHOW_PRICE_SCALE, false);
    ChartSetInteger(0, CHART_SHOW_DATE_SCALE, false);
    ChartSetInteger(0, CHART_FOREGROUND, original_background_color); //We set the background colur as a foreground color to make the foreground texts invinsible

    ChartSetInteger(0, CHART_SHOW_ASK_LINE, false);
    ChartSetInteger(0, CHART_SHOW_BID_LINE, false);
         
//--- Getting chart dimensions

    chart_width = (int)ChartGetInteger(0, CHART_WIDTH_IN_PIXELS);
    chart_height = (int)ChartGetInteger(0, CHART_HEIGHT_IN_PIXELS);

//--- Take screenshot

     MqlDateTime time_struct;
     TimeToStruct(TimeLocal(), time_struct);
     
     string filename = StringFormat("Screenshots\\%s.%s.%d.%d.%d.png", Symbol(), EnumToString(Period()), time_struct.day, time_struct.day_of_week, time_struct.hour);
     
     if(!ChartScreenShot(0, filename, chart_width, chart_height, ALIGN_CENTER))
      {
         printf("%s Failed to take a screeshot, Error = %s",__FUNCTION__,ErrorDescription(GetLastError()));
           
         // Restore original scale settings
          
         ChartSetInteger(0, CHART_SHOW_PRICE_SCALE, original_price_scale);
         ChartSetInteger(0, CHART_SHOW_DATE_SCALE, original_time_scale);
         ChartSetInteger(0, CHART_SHOW_ASK_LINE, true);
         ChartSetInteger(0, CHART_SHOW_BID_LINE, true);
          
         return false;
      }
      
    // Restore original scale settings
    
    ChartSetInteger(0, CHART_SHOW_PRICE_SCALE, original_price_scale);
    ChartSetInteger(0, CHART_SHOW_DATE_SCALE, original_time_scale);
    ChartSetInteger(0, CHART_FOREGROUND, original_foreground_color); //restore the foreground color
   
    ChartSetInteger(0, CHART_SHOW_ASK_LINE, true);
    ChartSetInteger(0, CHART_SHOW_BID_LINE, true);
         
   return true;
 }
//+------------------------------------------------------------------+
//|       Function to set a BMP image as chart background            |
//+------------------------------------------------------------------+
bool chartBackGroundSet(string filename, int width, int height)
{
    string obj_name = "background-img";
        
   if(!ObjectCreate(0,obj_name,OBJ_BITMAP_LABEL,0,0,0)) 
     { 
      printf("%s failed to create a bitmap in the chart window! Error = %s",__FUNCTION__,ErrorDescription(GetLastError())); 
      return(false); 
     } 
     
//--- set the path to the image file 
   if(!ObjectSetString(0,obj_name,OBJPROP_BMPFILE, filename)) 
     { 
      printf("%s failed to load the image! Error = %s",__FUNCTION__,ErrorDescription(GetLastError())); 
      return(false); 
     } 

//--- Position the image to cover the entire chart

    ObjectSetInteger(0, obj_name, OBJPROP_XDISTANCE, 0);
    ObjectSetInteger(0, obj_name, OBJPROP_YDISTANCE, 0);
    ObjectSetInteger(0, obj_name, OBJPROP_XSIZE, width);
    ObjectSetInteger(0, obj_name, OBJPROP_YSIZE, height);
    
//--- Send the image to the background

    ObjectSetInteger(0, obj_name, OBJPROP_BACK, true);
    ObjectSetInteger(0, obj_name, OBJPROP_ZORDER, -1);
    
//--- Make sure the object is visible
    ObjectSetInteger(0, obj_name, OBJPROP_SELECTABLE, false);
    ObjectSetInteger(0, obj_name, OBJPROP_HIDDEN, true);
    
//--- Redraw the chart to see changes

    ChartRedraw(0);    
//---
   return true;
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void showBars(bool show=true)
 { 
//--- Cleaning the chart

    ChartSetInteger(0, CHART_SHOW_PRICE_SCALE, true);
    ChartSetInteger(0, CHART_SHOW_DATE_SCALE, true);
    ChartSetInteger(0, CHART_SHOW_GRID, false); // Disable grid for cleaner images
    ChartSetInteger(0, CHART_SHOW_VOLUMES, false);
    ChartSetInteger(0, CHART_SHOW_TRADE_HISTORY, false);
    ChartSetInteger(0, CHART_AUTOSCROLL, true);  // prevent scrolling  
    ChartSetInteger(0, CHART_SHIFT, true);
    
    if (ChartGetInteger(0, CHART_SCALE) != chart_scale)
         ChartSetInteger(0, CHART_SCALE, chart_scale);
   
   if (show)
     {
         ChartSetInteger(0, CHART_COLOR_BACKGROUND, clrWhite);
         ChartSetInteger(0, CHART_COLOR_FOREGROUND, clrBlack);
         ChartSetInteger(0, CHART_COLOR_CHART_UP, clrTomato);
         ChartSetInteger(0, CHART_COLOR_CANDLE_BULL, clrTomato);
         ChartSetInteger(0, CHART_COLOR_CHART_DOWN, clrLightSeaGreen);
         ChartSetInteger(0, CHART_COLOR_CANDLE_BEAR, clrLightSeaGreen);
         ChartSetInteger(0, CHART_SHOW_ASK_LINE, true);
         ChartSetInteger(0, CHART_SHOW_BID_LINE, true);
         ChartSetInteger(0, CHART_COLOR_ASK, clrTurquoise);
     }
   else
     {
         ChartSetInteger(0, CHART_COLOR_BACKGROUND, clrWhite);
         ChartSetInteger(0, CHART_COLOR_FOREGROUND, clrBlack);
         
         ChartSetInteger(0, CHART_COLOR_CHART_UP, clrWhite);
         ChartSetInteger(0, CHART_COLOR_CANDLE_BULL, clrWhite);
         ChartSetInteger(0, CHART_COLOR_CHART_DOWN, clrWhite);
         ChartSetInteger(0, CHART_COLOR_CANDLE_BEAR, clrWhite);
         ChartSetInteger(0, CHART_SHOW_ASK_LINE, true);
         ChartSetInteger(0, CHART_SHOW_BID_LINE, true);
         ChartSetInteger(0, CHART_COLOR_ASK, clrTurquoise);
     }
     
   ChartRedraw();
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,const long& lparam,const double& dparam,const string& sparam)
  {
//--- Getting chart dimensions

    chart_width = (int)ChartGetInteger(0, CHART_WIDTH_IN_PIXELS);
    chart_height = (int)ChartGetInteger(0, CHART_HEIGHT_IN_PIXELS);
    
    ChartRedraw();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
